#include "callback_persdata.h"

#include <drive/backend/report/json.h>

// Acquisition

TPrivateDataAcquisionCallback::TPrivateDataAcquisionCallback(IServerReportBuilder::TPtr report, const NUserReport::TReportTraits& reportTraits)
    : IPrivateDataJsonCallback(reportTraits)
    , Report(report)
{
}

void TPrivateDataAcquisionCallback::DoProcessAllResponses() {
    TJsonReport::TGuard g(Report, HTTP_OK);
    TJsonReport& r = g.MutableReport();
    r.SetExternalReport(std::move(ResultReport));
    g.SetCode(HTTP_OK);
}
