#pragma once

#include <drive/backend/processors/service_app/config.h>
#include <drive/backend/processors/service_app/processor.h>

class IUserBasicDeletionProcessor: public TCommonServiceAppProcessorBase {
private:
    using TBase = TCommonServiceAppProcessorBase;

public:
    using TBase::TBase;

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;

protected:
    virtual TString GetType() const = 0;
    virtual TString GetTagToAdd(TUsersDB::TUserDeleteStatus userStatus, TJsonReport::TGuard& g) = 0;

    void AddDeletionAttempt(const TString& userId);
};

class TUserDeletionPassportProcessor: public TAppCommonRegistrator<TUserDeletionPassportProcessor, TEmptyConfig>, public IUserBasicDeletionProcessor {
private:
    using TBase = TAppCommonRegistrator<TUserDeletionPassportProcessor, TEmptyConfig>;

public:
    TUserDeletionPassportProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config)
        , IUserBasicDeletionProcessor(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "takeout_passport_userdeletion";
    }

private:
    TString GetType() const override {
        return GetTypeName();
    }

    TString GetTagToAdd(TUsersDB::TUserDeleteStatus userStatus, TJsonReport::TGuard& g) override;
};

class TUserDeletionClientProcessor: public TAppCommonRegistrator<TUserDeletionClientProcessor, TEmptyConfig>, public IUserBasicDeletionProcessor {
private:
    using TBase = TAppCommonRegistrator<TUserDeletionClientProcessor, TEmptyConfig>;

public:
    TUserDeletionClientProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config)
        , IUserBasicDeletionProcessor(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "takeout_userdeletion";
    }

private:
    TString GetType() const override {
        return GetTypeName();
    }

    TString GetTagToAdd(TUsersDB::TUserDeleteStatus userStatus, TJsonReport::TGuard& g) override;
};

class TUserDeleteStatusProcessor: public TAppCommonProcessor<TUserDeleteStatusProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserDeleteStatusProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "deletion_status";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserDupsProcessor: public TAppCommonProcessor<TUserDupsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserDupsProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_dups";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserInfoProcessorBase: public TCommonServiceAppProcessorBase {
private:
    using TBase =TCommonServiceAppProcessorBase;

public:
    using TBase::TBase;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserInfoProcessor: public TAppCommonProcessor<TUserInfoProcessor, TEmptyConfig, TUserInfoProcessorBase> {
private:
    using TBase = TAppCommonProcessor<TUserInfoProcessor, TEmptyConfig, TUserInfoProcessorBase>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_admin_portal_info";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TBaseUserInfoEditingProcessor : public TCommonServiceAppProcessorBase {
private:
    using TBase = TCommonServiceAppProcessorBase;

public:
    using TBase::TBase;

private:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& jsonValue) override;

    void CheckEditingRights(const TString& userId, TUserPermissions::TPtr permissions) const {
        return DoCheckEditPermissions(userId, permissions);
    }

    virtual void DoCheckEditPermissions(const TString& userId, TUserPermissions::TPtr permissions) const = 0;
};

class TUserInfoEditingProcessor
    : public TAppCommonRegistrator<TUserInfoEditingProcessor, TEmptyConfig>
    , public TBaseUserInfoEditingProcessor
{
private:
    using TBase = TAppCommonRegistrator<TUserInfoEditingProcessor, TEmptyConfig>;

public:
    TUserInfoEditingProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config)
        , TBaseUserInfoEditingProcessor(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "user_edit";
    }

    virtual void DoCheckEditPermissions(const TString& userId, TUserPermissions::TPtr permissions) const override;
};

class TUserModificationsHistoryProcessor: public TAppCommonProcessor<TUserModificationsHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserModificationsHistoryProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_modification_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserListProcessor: public TAppCommonProcessor<TUserListProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserListProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_list";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTagsSearchProcessor : public TAppCommonProcessor<TTagsSearchProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTagsSearchProcessor, TEmptyConfig>;

private:
    TVector<TString> ResolveSpecials(const TVector<TString>& rawTagsList) const;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_tag_search";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserDocumentPhotoStatusProcessor : public TAppCommonProcessor<TUserDocumentPhotoStatusProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserDocumentPhotoStatusProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_doc_photo_status";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserForceRegistrationProcessor : public TAppCommonProcessor<TUserForceRegistrationProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserForceRegistrationProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_force_register";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};



class TBaseUserForceDeletionProcessor : public TCommonServiceAppProcessorBase {
private:
    using TBase = TCommonServiceAppProcessorBase;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_force_delete";
    }

private:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) final;

    void CheckDeletePermissions(const TString& userId, TUserPermissions::TPtr permissions) const {
        DoCheckDeletePermissions(userId, permissions);
    }

    virtual void DoCheckDeletePermissions(const TString& userId, TUserPermissions::TPtr permissions) const = 0;
};

class TUserForceDeletionProcessor
    : public TAppCommonRegistrator<TUserForceDeletionProcessor, TEmptyConfig>
    , public TBaseUserForceDeletionProcessor
{
private:
    using TBase = TAppCommonRegistrator<TUserForceDeletionProcessor, TEmptyConfig>;

public:
    TUserForceDeletionProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config)
        , TBaseUserForceDeletionProcessor(config, context, authModule, server)
    {
    }

    static TString GetTypeName() {
        return "user_force_delete";
    }

private:
    void DoCheckDeletePermissions(const TString& /* userId */, TUserPermissions::TPtr /* permissions */) const override {
    }
};

class TUserExternalBlacklistAdditionProcessor : public TAppCommonProcessor<TUserExternalBlacklistAdditionProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserExternalBlacklistAdditionProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_blacklist_add";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserRequestsHistoryProcessor : public TAppCommonProcessor<TUserRequestsHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserRequestsHistoryProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_requests_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TTagOperatorsProcessor : public TAppCommonProcessor<TTagOperatorsProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TTagOperatorsProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "tag_operators_list";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TPhoneBindingHistoryProcessor : public TAppCommonProcessor<TPhoneBindingHistoryProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TPhoneBindingHistoryProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "phone_binding_history";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TPersonalDataRevisionProcessor : public TAppCommonProcessor<TPersonalDataRevisionProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TPersonalDataRevisionProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_persdata_revision";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserDocumentDataProcessorBase : public TCommonServiceAppProcessorBase {
private:
    using TBase = TCommonServiceAppProcessorBase;

public:
    using TBase::TBase;

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserDocumentDataProcessor : public TAppCommonProcessor<TUserDocumentDataProcessor, TEmptyConfig, TUserDocumentDataProcessorBase> {
private:
    using TBase = TAppCommonProcessor<TUserDocumentDataProcessor, TEmptyConfig, TUserDocumentDataProcessorBase>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_document_data";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

class TUserFeaturesProcessor: public TAppCommonProcessor<TUserFeaturesProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TUserFeaturesProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "user_features";
    }

    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
