#include "area_check.h"

#include <drive/backend/areas/areas.h>
#include <drive/backend/base/server.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/device_snapshot/manager.h>
#include <drive/backend/offers/manager.h>
#include <drive/backend/roles/permissions.h>

const TString TAllowedAreaCheck::Name = "allowed_area_check";
IWarningScreenChecker::TFactory::TRegistrator<TAllowedAreaCheck>
        TAllowedAreaCheck::Registrator(TAllowedAreaCheck::Name);

NJson::TJsonValue TAllowedAreaCheck::CheckImpl(const NDrive::IServer& server,
                                               const IReplyContext::TPtr context,
                                               TUserPermissions::TConstPtr permissions) const {
    const TString offerId = context->GetCgiParameters().Get("offer_id");
    Y_ENSURE(offerId, "Missing offer parameter");

    IOffer::TPtr offer;
    {
        auto session = server.GetDriveAPI()->template BuildTx<NSQL::ReadOnly>();
        auto baseOffer = server.GetOffersStorage()->RestoreOffer(offerId, permissions->GetUserId(), session).GetValueSync();
        Y_ENSURE(!!baseOffer, "Missing offer " << offerId);
        offer = std::dynamic_pointer_cast<IOffer>(baseOffer);
        Y_ENSURE(!!offer, "Not a vehicle offer " << offerId);
    }

    auto snapshot = server.GetSnapshotsManager().GetSnapshot(offer->GetObjectId());
    auto location = snapshot.GetLocation();
    Y_ENSURE(location, "Missing location for car " << offer->GetObjectId());

    TCarLocationContext clc =
            TCarLocationContext::BuildByCoord(offer->GetObjectId(), location->GetCoord(), server);
    TCarLocationFeatures clf = clc.GetCarAreaFeatures(false, nullptr, &server);
    const auto allowDrop = clf.OptionalAllowDrop();
    Y_ENSURE(allowDrop, "Failed to fetch car drop info");
    if (*allowDrop == EDropAbility::Allow) {
        return NJson::JSON_NULL;
    }

    return GetLocalizedLanding("main", permissions, server);
}
