#include "car_location.h"

#include "helpers.h"

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/device_snapshot/manager.h>
#include <drive/backend/roles/permissions.h>
#include <drive/library/cpp/searchserver/context/replier.h>

NJson::TJsonValue TCurrentCarLocationCheck::CheckImpl(const NDrive::IServer& server, const IReplyContext::TPtr context, TUserPermissions::TConstPtr permissions) const {
    const auto& settings = server.GetSettings();
    auto event = context->GetCgiParameters().Get("event");

    auto compilation = GetBillingSessionCompilationSafe(server, context, permissions);
    auto offer = compilation.GetCurrentOffer();
    Y_ENSURE(offer, "No offer in session " << compilation.GetSessionId());
    auto objectId = offer->GetObjectId();
    Y_ENSURE(objectId, "no object_id in offer " << offer->GetOfferId());

    auto snapshot = server.GetSnapshotsManager().GetSnapshot(objectId);
    auto tagsFilterSettingKey = "warning_screens.checkers." + event + "." + GetName() + ".area_tags_filter";
    auto tagsFilterString = permissions->GetSetting<TString>(settings, tagsFilterSettingKey);
    Y_ENSURE(tagsFilterString, "setting " << tagsFilterSettingKey << " is not set");
    auto tagsFilter = TBaseAreaTagsFilter::BuildFromString(*tagsFilterString);
    auto landingId = TString();
    if (tagsFilter.Filter(snapshot)) {
        landingId = "match." + event;
    } else {
        landingId = "nomatch." + event;
    }

    return GetLocalizedLanding(landingId, permissions, server);
}

const TString TCurrentCarLocationCheck::Name = "current_car_location";
IWarningScreenChecker::TFactory::TRegistrator<TCurrentCarLocationCheck> TCurrentCarLocationCheck::Registrator(TCurrentCarLocationCheck::Name);
