#include "car_model_check.h"

#include <drive/backend/base/server.h>
#include <drive/backend/cars/car.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/offers/manager.h>
#include <memory>

const TString TCarModelCheck::Name = "car_model_check";
IWarningScreenChecker::TFactory::TRegistrator<TCarModelCheck>
        TCarModelCheck::Registrator(TCarModelCheck::Name);

NJson::TJsonValue TCarModelCheck::CheckImpl(const NDrive::IServer& server, const IReplyContext::TPtr context,
                                            TUserPermissions::TConstPtr permissions) const {
    const TString offerId = context->GetCgiParameters().Get("offer_id");
    Y_ENSURE(offerId, "Missing offer parameter");

    auto session = server.GetDriveAPI()->template BuildTx<NSQL::ReadOnly>();
    IOffer::TPtr offer;
    {
        auto baseOffer = server.GetOffersStorage()->RestoreOffer(offerId, permissions->GetUserId(), session).GetValueSync();
        Y_ENSURE(baseOffer, "Missing offer " << offerId);
        offer = std::dynamic_pointer_cast<IOffer>(baseOffer);
        Y_ENSURE(offer, "Not a vehicle offer: " << offerId);
    }

    const auto carId = offer->GetObjectId();
    const auto carsData = server.GetDriveAPI()->GetCarsData()->FetchInfo(carId, session);
    const TDriveCarInfo* carInfo = carsData.GetResultPtr(carId);
    Y_ENSURE(carInfo, "Missing car: " << carId);

    return GetLocalizedLanding(carInfo->GetModel(), permissions, server);
}
