#pragma once

#include <drive/backend/abstract/localization.h>

#include <library/cpp/cgiparam/cgiparam.h>
#include <library/cpp/json/writer/json_value.h>
#include <library/cpp/object_factory/object_factory.h>

#include <rtline/util/types/expected.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>

class IReplyContext;
class TUserPermissions;

namespace NJson {
    class TJsonValue;
}

namespace NDrive {
    class IServer;
    class ISettings;
}

class IWarningScreenChecker {
public:
    using TFactory = NObjectFactory::TObjectFactory<IWarningScreenChecker, TString>;
    using TResponse = TExpected<NJson::TJsonValue, yexception>;
    using TEventArgs = TCgiParameters;

public:
    virtual ~IWarningScreenChecker() = default;

    virtual TString GetName() const = 0;

    TResponse Call(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> context, const TIntrusiveConstPtr<TUserPermissions> permissions) const;
    NJson::TJsonValue GetLocalizedLanding(const TString& landingId, TIntrusiveConstPtr<TUserPermissions> permissions, const NDrive::IServer& server) const;
    NJson::TJsonValue GetLocalizedLanding(const TString& landingString, const NDrive::IServer& server) const;
    NJson::TJsonValue GetLocalizedLanding(NJson::TJsonValue&& landing, const NDrive::IServer& server) const;
    TString GetLandingSettingId(const TString& landingId) const;
    TString GetLanding(const TString& landingId, TIntrusiveConstPtr<TUserPermissions> permissions, const NDrive::ISettings& settings) const;
    TEventArgs GetEventParameters(const TAtomicSharedPtr<IReplyContext> context, TIntrusiveConstPtr<TUserPermissions> permissions, const NDrive::ISettings& settings) const;

    ELocalization GetLocale() const {
        return Locale;
    }
    void SetLocale(ELocalization value) {
        Locale = value;
    }

private:
    virtual NJson::TJsonValue CheckImpl(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> context, TIntrusiveConstPtr<TUserPermissions> permissions) const = 0;

private:
    ELocalization Locale = DefaultLocale;
};
