#include "fixpoint_finish_area_check.h"

#include "helpers.h"

#include <drive/backend/base/server.h>
#include <drive/backend/data/chargable.h>
#include <drive/backend/offers/actions/fix_point.h>

const TString TFixPointFinishAreaCheck::Name = "fix_point_finish_area_check";
IWarningScreenChecker::TFactory::TRegistrator<TFixPointFinishAreaCheck>
        TFixPointFinishAreaCheck::Registrator(TFixPointFinishAreaCheck::Name);

NJson::TJsonValue TFixPointFinishAreaCheck::CheckImpl(const NDrive::IServer& server,
                                                      const IReplyContext::TPtr context,
                                                      TUserPermissions::TConstPtr permissions) const {
    auto compilation = GetBillingSessionCompilationSafe(server, context, permissions);
    if (!compilation.IsAccepted()) {
        return NJson::JSON_NULL;
    }

    auto state = compilation.GetCurrentOfferState();
    Y_ENSURE(state, "No offer state in default compilation in session " << compilation.GetSessionId());

    const TFixPointOfferState* fixPointOfferState =
            dynamic_cast<const TFixPointOfferState*>(state.Get());
    if (!fixPointOfferState) {
        return NJson::JSON_NULL;
    }

    if (fixPointOfferState->GetDropAvailableDef(false)) {
        return NJson::JSON_NULL;
    }

    return GetLocalizedLanding("main", permissions, server);
}
