#pragma once

#include <drive/backend/data/chargable.h>

TAtomicSharedPtr<const ISession> GetSession(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> context, TIntrusiveConstPtr<TUserPermissions> permissions);
TAtomicSharedPtr<const TBillingSession> GetBillingSession(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> context, TIntrusiveConstPtr<TUserPermissions> permissions);

TBillingSession::TBillingCompilation GetBillingSessionCompilationSafe(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> context, TIntrusiveConstPtr<TUserPermissions> permissions);
TMaybe<TBillingSession::TBillingCompilation> GetBillingSessionCompilation(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> context, TIntrusiveConstPtr<TUserPermissions> permissions);
