#include "long_term_replace.h"

#include "helpers.h"

#include <drive/backend/data/long_term.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/offers/actions/long_term.h>
#include <drive/backend/offers/manager.h>
#include <drive/backend/roles/manager.h>

NJson::TJsonValue TLongTermReplaceCheck::CheckImpl(const NDrive::IServer& server, const IReplyContext::TPtr context, TUserPermissions::TConstPtr permissions) const {
    auto api = server.GetDriveAPI();
    R_ENSURE(api, {}, "no DriveApi");

    auto locale = GetLocale();

    auto tx = api->template BuildTx<NSQL::ReadOnly>();
    auto billingSession = GetBillingSession(server, context, permissions);
    R_ENSURE(billingSession, {}, "no billing session");
    auto deviceTags = api->GetTagsManager().GetDeviceTags().RestoreObject(billingSession->GetObjectId(), tx);
    R_ENSURE(deviceTags, {}, "cant get device tags", tx);
    auto replacingTagRaw = deviceTags->GetTag(TReplaceCarTag::TypeName);
    R_ENSURE(replacingTagRaw, {}, "no replacing tag on car");
    auto replacingTag = replacingTagRaw->MutableTagAs<TReplaceCarTag>();
    R_ENSURE(replacingTag, {}, "replacing tag has wrong type");
    auto tmpOfferId = replacingTag->GetTmpOfferId();
    R_ENSURE(tmpOfferId, {}, "no offer id in replacing tag");

    auto tmpOffer = server.GetOffersStorage()->RestoreOffer(tmpOfferId, permissions->GetUserId(), tx).GetValueSync();
    R_ENSURE(tmpOffer, {}, "tmp offer not found", tx);

    auto landingString = GetLanding("main", permissions, server.GetSettings());
    landingString = tmpOffer->FormDescriptionElement(landingString, locale, server.GetLocalization());

    auto landing = GetLocalizedLanding(landingString, server);
    R_ENSURE(tx.Commit(), {}, "cannot commit tx", tx);
    return landing;
}

const TString TLongTermReplaceCheck::Name = "long_term_replace_check";
IWarningScreenChecker::TFactory::TRegistrator<TLongTermReplaceCheck> TLongTermReplaceCheck::Registrator(TLongTermReplaceCheck::Name);
