#include "phone_check.h"

#include <drive/backend/base/server.h>
#include <drive/backend/roles/permissions.h>

const TString TUserPhoneCheck::Name = "user_phone_check";
IWarningScreenChecker::TFactory::TRegistrator<TUserPhoneCheck>
        TUserPhoneCheck::Registrator(TUserPhoneCheck::Name);

NJson::TJsonValue TUserPhoneCheck::CheckImpl(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> /*context*/,
                                        TIntrusiveConstPtr<TUserPermissions> permissions) const {
    if (permissions->IsPhoneVerified()) {
        return NJson::JSON_NULL;
    }

    return GetLocalizedLanding("main", permissions, server);
}
