#pragma once

#include "checker.h"

namespace NDrive {
    class ISettings;
}
class ICommonOffer;
class TDriveAPI;

class TPrepayCheck: public IWarningScreenChecker {
public:
    TString GetName() const override {
        return Name;
    }

    static const TString Name;
    static IWarningScreenChecker::TFactory::TRegistrator<TPrepayCheck> Registrator;

private:
    NJson::TJsonValue CheckImpl(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> context, TIntrusiveConstPtr<TUserPermissions> permissions) const override;
    TString GetSpecialLanding(const NDrive::ISettings& settings,
                              TIntrusiveConstPtr<TUserPermissions> permissions, const ICommonOffer& offer,
                              const TDriveAPI& driveApi) const;
};
