#pragma once

#include "checker.h"

#include <drive/backend/processors/common_app/processor.h>
#include <drive/backend/processors/service_app/config.h>

class IWarningScreenChecker;

class TWarningScreenProcessor: public TAppCommonProcessor<TWarningScreenProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TWarningScreenProcessor, TEmptyConfig>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "warning_screen";
    }

    void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};

namespace NDrive {

    TVector<THolder<IWarningScreenChecker>> GetWarningScreenCheckers(const TString& event, ELocalization locale, TUserPermissions::TPtr permissions);

}
