#pragma once

#include "checker.h"

class TSessionDebtCheck: public IWarningScreenChecker {
public:
    TString GetName() const override {
        return Name;
    }

    static const TString Name;
    static IWarningScreenChecker::TFactory::TRegistrator<TSessionDebtCheck> Registrator;

private:
    NJson::TJsonValue CheckImpl(const NDrive::IServer& server, TAtomicSharedPtr<IReplyContext> context, TIntrusiveConstPtr<TUserPermissions> permissions) const override;
};

class TActiveSessionCheck: public IWarningScreenChecker {
public:
    static const TString Name;
    static IWarningScreenChecker::TFactory::TRegistrator<TActiveSessionCheck> Registrator;

public:
    TString GetName() const override {
        return Name;
    }

private:
    NJson::TJsonValue CheckImpl(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> context, TIntrusiveConstPtr<TUserPermissions> permissions) const override;
};
