#include "simple_check.h"

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/roles/permissions.h>

#include <drive/library/cpp/searchserver/context/replier.h>

const TString TSimpleCheck::Name = "simple_check";
IWarningScreenChecker::TFactory::TRegistrator<TSimpleCheck>
        TSimpleCheck::Registrator(TSimpleCheck::Name);

NJson::TJsonValue TSimpleCheck::CheckImpl(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> context,
                                        TIntrusiveConstPtr<TUserPermissions> permissions) const {
    const auto eventArgs = GetEventParameters(context, permissions, server.GetSettings());
    const TString landingId = eventArgs.Get("landing_id");
    Y_ENSURE(landingId, "Missing landing_id event arg");
    return GetLocalizedLanding(landingId, permissions, server);
}
