#include "standard_with_discount_area_offer_finish_area_check.h"

#include "helpers.h"
#include <drive/backend/base/server.h>
#include <drive/backend/data/chargable.h>
#include <drive/backend/offers/offers/standard_with_discount_area.h>

const TString TStandardWithDiscountAreaOfferFinishAreaCheck::Name = "point_b_finish_area_check";
IWarningScreenChecker::TFactory::TRegistrator<TStandardWithDiscountAreaOfferFinishAreaCheck>
        TStandardWithDiscountAreaOfferFinishAreaCheck::Registrator(TStandardWithDiscountAreaOfferFinishAreaCheck::Name);

NJson::TJsonValue TStandardWithDiscountAreaOfferFinishAreaCheck::CheckImpl(const NDrive::IServer& server, const IReplyContext::TPtr context, TUserPermissions::TConstPtr permissions) const {
    auto compilation = GetBillingSessionCompilationSafe(server, context, permissions);
    if (!compilation.IsAccepted()) {
        return NJson::JSON_NULL;
    }

    auto currentState = compilation.GetCurrentOfferState();
    Y_ENSURE(currentState, "No offer state in default compilation in session " << compilation.GetSessionId());

    const auto state = std::dynamic_pointer_cast<TStandardWithDiscountAreaOfferState>(currentState);
    if (!state) {
        return NJson::JSON_NULL;
    }

    if (state->GetInFinishPolygon()) {
        return NJson::JSON_NULL;
    }

    return GetLocalizedLanding("main", permissions, server);
}
