#include "status_check.h"

#include <drive/backend/base/server.h>
#include <drive/backend/roles/permissions.h>

const TString TUserStatusCheck::Name = "user_status_check";
IWarningScreenChecker::TFactory::TRegistrator<TUserStatusCheck>
        TUserStatusCheck::Registrator(TUserStatusCheck::Name);

namespace {
    const TSet<TString> ALLOWED_STATUSES = {
        NDrive::UserStatusActive,
        NDrive::UserStatusOnboarding,
    };
};

NJson::TJsonValue TUserStatusCheck::CheckImpl(const NDrive::IServer& server, const TAtomicSharedPtr<IReplyContext> /*context*/,
                                        TIntrusiveConstPtr<TUserPermissions> permissions) const {
    if (ALLOWED_STATUSES.contains(permissions->GetStatus())) {
        return NJson::JSON_NULL;
    }

    return GetLocalizedLanding("main", permissions, server);
}
