#include "processor.h"

#include <drive/backend/data/user_tags.h>
#include <drive/backend/tags/tags_manager.h>

#include <util/system/env.h>

#include <contrib/libs/jwt-cpp/include/jwt-cpp/jwt.h>

void TGetProAuthJWT::ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) {
    Y_UNUSED(requestData);
    
    const auto& userId = permissions->GetUserId();
    auto token = GetString(Context->GetCgiParameters(), "jwt");
    auto ourPrivateKey = GetEnv("PRO_AUTH_OUR_PRIVATE_KEY");
    auto theirPublicKey = GetEnv("PRO_AUTH_THEIR_PUBLIC_KEY");
    auto decoded = jwt::decode(token);
    auto verifier = jwt::verify()
                        .allow_algorithm(jwt::algorithm::es384{ theirPublicKey });

    verifier.verify(decoded);

    TString deeplink;

    if (DriveApi->GetTagsManager().GetUserTags().GetCachedObject(userId)->HasTag("taxi_fleet_auth_info")) {
        g.AddReportElement("status", "already_registered");
        deeplink = GetHandlerSettingDef<TString>("deeplink_template_already_registered", "");
    } else {
        g.AddReportElement("status", "new");
        deeplink = GetHandlerSettingDef<TString>("deeplink_template_new", "");
    }

    auto newToken = jwt::create()
                        .set_type("JWT")
                        .set_payload_claim("park_id", decoded.get_payload_claim("park_id"))
                        .set_payload_claim("driver_profile_id", decoded.get_payload_claim("driver_profile_id"))
                        .set_payload_claim("drive_user_id", jwt::claim(userId))
                        .sign(jwt::algorithm::es384{ "", ourPrivateKey });

    SubstGlobal(deeplink, "_JWT_", newToken);
    g.AddReportElement("result", deeplink);
    g.SetCode(HTTP_OK);
}
