#pragma once

#include <drive/backend/abstract/base.h>
#include <drive/backend/abstract/notifier.h>
#include <drive/backend/database/drive_api.h>
#include <drive/backend/database/drive/private_data.h>
#include <drive/backend/logging/events.h>
#include <drive/backend/report/json.h>
#include <drive/backend/users/yang.h>

#include <util/generic/yexception.h>

namespace NYangAssignment {
    void FillFraudReasons(TYangDocumentVerificationAssignment& assignment, const NJson::TJsonValue& verificationStatuses);
};

class TPrefilledDataAcquisionCallback : public IPrivateDataAcquisitionCallback {
private:
    const NDrive::IServer* Server;
    IServerReportBuilder::TPtr Report;
    const bool PassportBioStatus;
    const bool PassportRegStatus;
    const bool LicenseBackStatus;
    const bool LicenseFrontStatus;
    const TDriveUserData UserData;

    NJson::TJsonValue ResultReport;

    TMutex Mutex;

public:
    TPrefilledDataAcquisionCallback(const NDrive::IServer* server, IServerReportBuilder::TPtr report, const bool passportBioStatus, const bool passportRegStatus, const bool passportSelfieStatus, const bool licenseBackStatus, const bool licenseFrontStatus, const TDriveUserData& userData);

private:
    virtual void DoOnPassportReceipt(const TString& /*revision*/, const TUserPassportData& passport) override;
    virtual void DoOnDrivingLicenseReceipt(const TString& /*revision*/, const TUserDrivingLicenseData& drivingLicense) override;
    void DoOnUnsuccessfulResponse(EPrivateDataType /*documentType*/, const TString& /*revision*/) override {}

    virtual void ProcessAllResponses() override;
};
