#include "data_fetchers.h"

void TYangUserInfoProcessor::ProcessServiceRequest(TJsonReport::TGuard &g, TUserPermissions::TPtr permissions, const NJson::TJsonValue &requestData) {
    TBase::ProcessServiceRequest(g, permissions, requestData);
}

void TYangUserDocumentDataProcessor::ProcessServiceRequest(TJsonReport::TGuard &g, TUserPermissions::TPtr permissions, const NJson::TJsonValue &requestData) {
    TBase::ProcessServiceRequest(g, permissions, requestData);
}

NJson::TJsonValue TYangUserDocumentDataProcessor::EnrichRequestData(const NJson::TJsonValue& requestData, const TYangDocumentVerificationAssignment& assignment) const {
    auto enrichedRequestData = TBase::EnrichRequestData(requestData, assignment);

    const TCgiParameters& cgi = Context->GetCgiParameters();
    auto photoType = GetString(requestData, "photo_type", false);
    if (!photoType) {
        photoType = GetString(cgi, "photo_type", true);
    }

    NUserDocument::EType documentType = NUserDocument::EType::Unknown;
    R_ENSURE(
        photoType && TryFromString(photoType, documentType),
        TBase::ConfigHttpStatus.EmptyRequestStatus,
        "malformed photo_type " + photoType
    );

    auto photoId = assignment.GetDocumentId(documentType);
    enrichedRequestData["photo_id"] = photoId;

    return enrichedRequestData;
}
