#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TYangProxyCommonProcessor: public TCommonServiceAppProcessorBase {
private:
    using TBase = TCommonServiceAppProcessorBase;

public:
    using TBase::TBase;

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
    virtual void ProcessRequest(TJsonReport::TGuard& g, const NJson::TJsonValue& requestData) = 0;
};

class TYangUserTextdataProcessorTraits: public TYangProxyCommonProcessor {
private:
    using TBase = TYangProxyCommonProcessor;

protected:
    void ProcessGetNewReport(TJsonReport::TGuard& g, const TDriveUserData& user, NDrive::TEntitySession& session);
    void ProcessGet(TJsonReport::TGuard& g, const TDriveUserData& user, NDrive::TEntitySession& session);
    void FillDocumentsData(TJsonReport::TGuard& g, const NJson::TJsonValue& requestData, const TString& assignmentId, TDriveUserData& user, TMaybe<TUserPassportData>& passportData,  TMaybe<TUserDrivingLicenseData>& drivingLicenseData);

public:
    using TBase::TBase;
};

class TYangUserTextdataProcessor: public TAppCommonProcessor<TYangUserTextdataProcessor, TEmptyConfig, TYangUserTextdataProcessorTraits> {
private:
    using TBase = TAppCommonProcessor<TYangUserTextdataProcessor, TEmptyConfig, TYangUserTextdataProcessorTraits>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "yang_user_textdata";
    }

    virtual void ProcessRequest(TJsonReport::TGuard& g, const NJson::TJsonValue& requestData) override;
};

class TYangUserCompletionHistoryProcessor: public TAppCommonProcessor<TYangUserCompletionHistoryProcessor, TEmptyConfig, TYangProxyCommonProcessor> {
private:
    using TBase = TAppCommonProcessor<TYangUserCompletionHistoryProcessor, TEmptyConfig, TYangProxyCommonProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "yang_user_textdata_history";
    }

    virtual void ProcessRequest(TJsonReport::TGuard& g, const NJson::TJsonValue& requestData) override;
};

class TYangFaceMatchingResultsProcessor: public TAppCommonProcessor<TYangFaceMatchingResultsProcessor, TEmptyConfig, TYangProxyCommonProcessor> {
private:
    using TBase = TAppCommonProcessor<TYangFaceMatchingResultsProcessor, TEmptyConfig, TYangProxyCommonProcessor>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "yang_face_matching_results";
    }

    virtual void ProcessRequest(TJsonReport::TGuard& g, const NJson::TJsonValue& requestData) override;
};
