#pragma once

#include <drive/backend/processors/common_app/processor.h>

class TParkingProcessor: public TAppCommonProcessor<TParkingProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TParkingProcessor, TEmptyConfig>;

public:
    static TString GetTypeName() {
        return "parking";
    }

    TParkingProcessor(const THandlerConfig& config, IReplyContext::TPtr context, IAuthModule::TPtr authModule, const NDrive::IServer* server)
        : TBase(config, context, authModule, server)
    {
    }

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& /*g*/, TUserPermissions::TPtr /*permissions*/, const NJson::TJsonValue& /*requestData*/) override;
};

class TParkingListProcessor: public TAppCommonProcessor<TParkingListProcessor, TEmptyConfig> {
private:
    using TBase = TAppCommonProcessor<TParkingListProcessor, TEmptyConfig>;

public:
    static TString GetTypeName() {
        return "parking_list";
    }

public:
    using TBase::TBase;

protected:
    virtual void ProcessServiceRequest(TJsonReport::TGuard& g, TUserPermissions::TPtr permissions, const NJson::TJsonValue& requestData) override;
};
