#pragma once

#include <util/generic/ptr.h>
#include <util/generic/set.h>
#include <util/generic/string.h>

class IPromoProfit;

class IPromoCodeGenerator {
public:
    virtual TAtomicSharedPtr<IPromoProfit> BuildPromoProfit() const = 0;
    virtual const TString& GetName() const = 0;
};

class IPromoCodeUsage {
public:
    virtual const TSet<TString>& GetAvailableTypes() const = 0;
};

class IPromoTagProfit {
public:
    virtual const TString& GetTagName() const = 0;
};
