#pragma once

#include "action.h"
#include "entities.h"

#include <rtline/util/types/expected.h>

class TUserPermissions;
using TUserPermissionsPtr = TIntrusiveConstPtr<TUserPermissions>;

namespace NDrive {
    class TEntitySession;
}

class IPromoCodesManager {
public:
    struct TApplyContext {
        TString Code;
        ui32 PaymentSum = 0;
        TApplyContext(const TString& code)
            : Code(code)
        {
        }
    };
public:
    virtual ~IPromoCodesManager() = default;
    virtual bool GenerateCodes(const ui32 count, const IPromoCodeGenerator& generator, const TGeneratorContext& context, const TString& userId, TVector<TPromoCodeMeta>& codes, NDrive::TEntitySession& session) const = 0;
    virtual bool GiveOutCodes(const TSet<TString>& ids, const TString& givenOutInfo, TUserPermissionsPtr permissions, TVector<TPromoCodeMeta>& codes, NDrive::TEntitySession& session) const = 0;
    virtual bool GiveOutCodes(const TString& generator, const ui32 count, const TString& givenOutInfo, TUserPermissionsPtr permissions, TVector<TPromoCodeMeta>& codes, NDrive::TEntitySession& session) const = 0;
    virtual bool RemoveCodes(const TSet<TString>& ids, const bool force, const TString& userId, NDrive::TEntitySession& session) const = 0;
    virtual bool ApplyCode(const TApplyContext& context, const TString& objectId, TUserPermissionsPtr permissions, NJson::TJsonValue& jsonReport, NDrive::TEntitySession& session, NDrive::TEntitySession& chatSession) const = 0;
    virtual bool GetPromoCodes(const TPromoCodesSearchContext& filter, TUserPermissionsPtr permissions, TVector<TAtomicSharedPtr<IPromoCodeMetaReport>>& result, NDrive::TEntitySession& session) const = 0;
    virtual bool GetPromoProfit(const TString& code, TAtomicSharedPtr<IPromoProfitBase>& result, NDrive::TEntitySession& session) const = 0;
    virtual TMaybe<TVector<TPromoCodeMeta>> GetMetaByCode(const TString& code, NDrive::TEntitySession& session) const = 0;
    virtual bool GetUserActivationsHistory(const TString& userId, const TInstant startInstant, TVector<TAtomicSharedPtr<IPromoCodeMetaReport>>& codeReports, NDrive::TEntitySession& session) const = 0;
};
