#pragma once

#include "config.h"

#include <drive/backend/abstract/frontend.h>

#include <drive/library/cpp/blackbox/client.h>

#include <library/cpp/blackbox2/blackbox2.h>
#include <library/cpp/tvmauth/client/facade.h>

class TAccountChecker {
    enum EScoringLevel {
        NoScoring,
        Weak,
        Full
    };

    TAccountCheckerConfig Config;
    const NDrive::IServer* Server;
    THolder<NDrive::TBlackboxClient> BlackboxClient;

public:
    TAccountChecker(const TAccountCheckerConfig& config, const NDrive::IServer* server);

    bool IsPassed(const ui64 passportUid, const TSet<TString>& countries, const TString& notifierName = "") const;

    TInstant GetCachedCreationDate(const ui64 passportUid) const;

private:
    mutable TMap<ui64, TInstant> CachedCreationDate;

    EScoringLevel GetScoringLevel(const TSet<TString>& countries) const;
    NBlackbox2::TOptions BuildBlackboxOptions() const;
    bool IsEnoughSuids(const NBlackbox2::TDBFields& dbFields) const;
    bool IsOldEnough(const ui64 passportUid, const NBlackbox2::TDBFields& dbFields) const;
};
