#pragma once

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/logger/global/global.h>
#include <library/cpp/mediator/global_notifications/system_status.h>

#include <rtline/util/network/neh.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/map.h>
#include <util/stream/file.h>

class TAccountCheckerConfig {
    R_READONLY(TString, Host);
    R_READONLY(TString, Route);
    R_READONLY(ui32, SelfTvmId, 0);
    R_READONLY(ui32, DestinationTvmId, 0);
    R_READONLY(TDuration, MinAccountAge);
    R_READONLY(ui32, MinSuidWeight, 2);

    R_READONLY(TSet<TString>, NoScoringCountries);
    R_READONLY(TSet<TString>, FullScoringCountries);

    R_READONLY(TSet<TString>, HighPrioritySuids);
    R_READONLY(TSet<TString>, LowPrioritySuids);

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;

    static TAccountCheckerConfig ParseFromString(const TString& configStr);

private:
    void CreateSet(TSet<TString>& destination, const TString& rawString);
};

class TUserRegistrationManagerConfig {
    R_READONLY(TString, ChatId, "registration");
    R_READONLY(TString, BanChatId, "ban");
    R_READONLY(TString, NotifierName);
    R_READONLY(TDuration, MinRequiredAge, TDuration::Days(365 * 21));
    R_READONLY(TDuration, MinRequiredExperience, TDuration::Days(365 * 2));
    R_READONLY(ui32, AutoBanThreshold, 6);
    R_READONLY(TString, SensitiveDataHashesKey);

    R_READONLY(bool, IsAccountCheckEnabled, true);
    R_READONLY(bool, IsNewChatEnabled, true);
    R_READONLY(bool, IsPrimaryDBUsed, true);

    R_READONLY(NSimpleMeta::TConfig, RequestConfig);
    R_READONLY(TAccountCheckerConfig, AccountCheckerConfig);

    R_READONLY(TString, VerificationStatusTag, "registration_info");
    R_READONLY(TString, VerificationStatusField, "resolution");
    R_READONLY(TString, ExpectedResolutionStatus, "enter");

    R_READONLY(
        TSet<TString>,
        ServiceRoles,
        TSet<TString>({
            "GR_installator_47_Vega",
            "GR_tyre_performer",
            "installator",
            "installator_Major",
            "installator_admin",
            "installator_base",
            "installator_vega",
            "major_maintenance_operator",
            "new_car_operator",
            "tyre_manager",
            "tyre_operator",
            "tyre_performer"
        })
    );

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;

    static TUserRegistrationManagerConfig ParseFromString(const TString& configStr);
};
