#include "hasher.h"

#include <library/cpp/openssl/holders/hmac.h>

TSensitiveDataHasher::TSensitiveDataHasher(const TString& hrKey) {
    CHECK_WITH_LOG(hrKey.size() / 2 == HashingKeySize);
    for (size_t i = 0; i < HashingKeySize; ++i) {
        ui8 b1 = FromHexDigit(hrKey[i * 2]);
        ui8 b2 = FromHexDigit(hrKey[i * 2 + 1]);
        HashingKey[i] = (b1 << 4) + b2;
    }
}

TString TSensitiveDataHasher::GetHash(const TString& content) const {
    NOpenSSL::THmacCtx ctx;
    unsigned char md[EVP_MAX_MD_SIZE];
    unsigned rlen = 0;
    HMAC_Init_ex(ctx, HashingKey, HashingKeySize, EVP_sha1(), nullptr);
    HMAC_Update(ctx, reinterpret_cast<const unsigned char*>(content.c_str()), content.size());
    HMAC_Final(ctx, md, &rlen);

    TString result = "";
    for (size_t i = 0; i < rlen; ++i) {
        result += ToHexDigit(md[i] >> 4);
        result += ToHexDigit(md[i] & 15);
    }

    return result;
}

char TSensitiveDataHasher::ToHexDigit(const ui8 digit) {
    return digit < 10 ? '0' + digit : 'a' + digit - 10;
}

ui8 TSensitiveDataHasher::FromHexDigit(const char ch) {
    return ch < 'a' ? ch - '0' : ch - 'a' + 10;
}
