#pragma once

#include <contrib/libs/openssl/include/openssl/evp.h>
#include <contrib/libs/openssl/include/openssl/hmac.h>

#include <library/cpp/logger/global/global.h>
#include <library/cpp/openssl/holders/evp.h>

class TSensitiveDataHasher {
    static const size_t HashingKeySize = 16;

private:
    unsigned char HashingKey[HashingKeySize];

public:
    TSensitiveDataHasher(const TString& hrKey);

    TString GetHash(const TString& content) const;

    static char ToHexDigit(const ui8 digit);

    static ui8 FromHexDigit(const char ch);
};
