#pragma once

#include <drive/backend/users/user_documents.h>

#include <util/generic/string.h>

namespace NBans {
    enum EReason {
        DrivingBan /* "blocked_driving_ban" */,
        DuplicateLicense /* "blocked_duplicate_driver_license" */,
        DuplicatePassport /* "blocked_duplicate_namber_pass" */,
        OldLicense /* "old_license" */,
        SpeedAsshole /* "speed_asshole" */,
        TooOld /* "too_old" */,
        Other /* "blocked_other" */,
        Auto /* "blocked_auto" */,
        Resubmit /* "blocked_for_resubmit" */,
    };
};

namespace NUserConnections {
    using TSimilarityTraits = ui32;
    enum ESimilarityTraits: ui32 {
        Device = 1 << 0 /* "Device" */,
        DocumentHashes = 1 << 1 /* "DocumentHashes" */,
        UserFields = 1 << 2 /* "UserFields" */,
    };
};

namespace NDataTransfer {
    using TDataTransferTraits = ui32;
    enum EDataTransferTraits: ui32 {
        Tags = 1 << 0 /* "Tags" */,
        Roles = 1 << 1 /* "Roles" */,
        Bonuses = 1 << 2 /* "Bonuses" */,
        FirstRide = 1 << 3 /* "FirstRide" */,
    };
    static constexpr TDataTransferTraits TransferAll = Max<TDataTransferTraits>();
    static constexpr TDataTransferTraits TransferNone = Min<TDataTransferTraits>();
}

class TBlacklistExternal;

class TYangDocumentVerificationAssignment;
class TDriveUserData;
class TUserPassportData;
class TUserDrivingLicenseData;
class TInstant;
class TSimpleChatBot;

class TUserRegistrationManagerConfig;
class IChatRobot;

namespace NDrive {
    class TEntitySession;
}

class IUserRegistrationManager {
public:
    struct TBlacklistOptions {
        NUserConnections::TSimilarityTraits Traits = 0;
        bool Direct = true;
        bool Reverse = true;
        bool SetComment = false;
        bool VerifiedDeviceIdOnly = false;
    };

public:
    const TString EmptyFieldHash = "05f0968218785ac4158eedde85b559bb7ffec349";

    virtual bool HandleVerifiedAssignment(TYangDocumentVerificationAssignment& recentAssignment, const TString& operatorUserId, TInstant actuality, const TUserPassportData* passportExt = nullptr, const TUserDrivingLicenseData* drivingLicenseExt = nullptr) const = 0;
    virtual bool DoBackgroundCheckEntrance(TDriveUserData& userData, const TString& operatorUserId, const TUserPassportData* passportExt = nullptr, const TUserDrivingLicenseData* drivingLicenseExt = nullptr, TString chatId = "", TString topic = "") const = 0;

    virtual bool Approve(TDriveUserData& userData, const TString& operatorUserId, const TSimpleChatBot* chatRobotPtr, const TString& topic) const = 0;

    virtual bool BanUser(const TString& userId, const TString& operatorId, const NBans::EReason reason, NDrive::TEntitySession& session) const = 0;
    virtual bool UnbanUser(const TString& userId, const TString& operatorId, NDrive::TEntitySession& session) const = 0;
    virtual bool IsSubjectToBan(const TString& userId, NDrive::TEntitySession& session) const = 0;
    virtual bool IsSubjectToFinishBan(const TString& userId, NDrive::TEntitySession& session) const = 0;
    virtual ui32 GetBanThreshold() const = 0;

    virtual bool ActualizeBlacklistBans(const TString& operatorUserId, const TVector<TString>& tagNames, const TString& dupsTagName, const TBlacklistOptions& options) const = 0;
    virtual TBlacklistExternal* GetBlacklistExternal() const = 0;

    virtual bool MoveData(TDriveUserData& userData, const TDriveUserData* twinData, const TString& operatorUserId, NDrive::TEntitySession& session, NDataTransfer::TDataTransferTraits traits = NDataTransfer::TransferAll) const = 0;

    virtual TString GetDocumentNumberHash(const TString& number) const = 0;
    virtual TString GetNotifierName() const = 0;
    virtual TUserRegistrationManagerConfig GetConfig() const = 0;
    virtual bool ReaskDocumentPhotos(const TString& userId, const ui32 resubmitMask, NDrive::TEntitySession& tx, const TString& operatorId, const TString& chatId = "", const TVector<TDocumentResubmitOverride>& resubmitOverride = {}) const = 0;

    virtual bool DeduceChatRobot(const TString& userId, TString& robotId, TString& topic) const = 0;

    virtual ~IUserRegistrationManager() = default;
};
