#pragma once

#include "abstract.h"

#include <drive/library/cpp/searchserver/context/replier.h>

#include <library/cpp/json/writer/json_value.h>

class TJsonReport: public IServerReportBuilder {
private:
    using TBase = IServerReportBuilder;

private:
    R_FIELD(bool, SortKeys, false);
    TMap<TString, TString> StrReports;

private:
    NJson::TJsonValue Report = NJson::JSON_NULL;
    NJson::TJsonValue EventLog = NJson::JSON_ARRAY;
    TInstant LastEvent = TInstant::Zero();
    TInstant FirstEvent = TInstant::Zero();

protected:
    virtual void DoAddEvent(TInstant timestamp, NJson::TJsonValue&& e) override;
    virtual void DoFinish(const TCodedException& e) override;
    using TBase::DoFinish;

    bool ShouldSortKeys() const;

public:
    class TGuard: public TBase::TGuard {
    private:
        using TGuardBase = TBase::TGuard;

    public:
        TGuard(IServerReportBuilder::TPtr report, int code = HTTP_INTERNAL_SERVER_ERROR);

        void AddReportElement(TStringBuf name, NJson::TJsonValue&& elem, const bool allowUndefined = true) {
            JsonReport.AddReportElement(name, std::move(elem), allowUndefined);
        }
        void AddReportElementString(TStringBuf name, TString&& elem) {
            JsonReport.AddReportElementString(name, std::move(elem));
        }

        void SetExternalReport(NJson::TJsonValue&& report) {
            JsonReport.SetExternalReport(std::move(report));
        }
        void SetExternalReportString(TString&& report) {
            JsonReport.SetExternalReportString(std::move(report));
        }

        TJsonReport& MutableReport() {
            return JsonReport;
        }

    private:
        TJsonReport& JsonReport;
    };

public:
    using TBase::TBase;

    void AddReportElement(TStringBuf name, NJson::TJsonValue&& elem, const bool allowUndefined = true);
    void AddReportElementString(TStringBuf name, TString&& elem);

    void SetExternalReport(NJson::TJsonValue&& report);
    void SetExternalReportString(TString&& report);

private:
    bool PrintReport(IOutputStream& so) const;
};
