#include "action.h"

NJson::TJsonValue TDBAction::BuildJsonReport() const {
    NJson::TJsonValue result = NJson::JSON_NULL;
    if (!!Action) {
        result = Action->BuildJsonReport();
    }
    return result;
}

NStorage::TTableRecord TDBAction::SerializeToTableRecord() const {
    Y_ENSURE_BT(Action);
    return Action->SerializeToTableRow();
}

TDBAction TDBAction::Clone() const {
    TDBAction newAction;
    Y_ENSURE_BT(newAction.Parse(SerializeToTableRecord(), false));
    return newAction;
}

TUserAction::TPtr TDBAction::BuildWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* hContext) {
    Y_ENSURE(values.size() > static_cast<size_t>(decoder.GetTypeName()), "invalid values size: " << values.size() << ' ' << decoder.GetTypeName());
    const TStringBuf& typeName = values[decoder.GetTypeName()];
    TUserAction::TPtr result = TUserAction::TFactory::Construct((TString)typeName);
    if (!result) {
        WARNING_LOG << "Cannot construct action with type: " << typeName << Endl;
        return nullptr;
    }

    if (!result->DeserializeWithDecoder(decoder, values, hContext)) {
        WARNING_LOG << "action ignored: " << JoinSeq(", ", values) << Endl;
        return nullptr;
    }
    return result;
}

bool TDBAction::DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* hContext) {
    Action = BuildWithDecoder(decoder, values, hContext);
    return !!Action;
}

bool TDBAction::Parse(const NStorage::TTableRecord& row, bool strict) {
    Action = TUserAction::BuildFromTableRow(row, strict);
    return Action != nullptr;
}
