#pragma once

#include <drive/backend/actions/abstract/action.h>

class TDBAction {
private:
    TUserAction::TPtr Action;

public:
    class TDecoder: public TUserAction::TDecoder {
    private:
        using TBase = typename TUserAction::TDecoder;

    private:
        R_FIELD(i32, TypeName, -1);

    public:
        TDecoder() = default;
        TDecoder(const TMap<TString, ui32>& decoderBase)
            : TBase(decoderBase)
        {
            TypeName = TBase::GetFieldDecodeIndex("action_type", decoderBase);
        }
    };

public:
    TUserAction::TPtr BuildWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* hContext);
    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* hContext);
    bool Parse(const NStorage::TTableRecord& row, bool strict = true);

public:
    TDBAction() = default;
    TDBAction(THolder<TUserAction> action)
        : Action(std::move(action))
    {
    }

    TDBAction Clone() const;

    NJson::TJsonValue BuildJsonReport() const;
    NStorage::TTableRecord SerializeToTableRecord() const;

    explicit operator bool() const {
        return Action.Get() != nullptr;
    }

    const TUserAction* operator->() const {
        Y_ENSURE_BT(Action);
        return Action.Get();
    }

    const TUserAction& operator*() const {
        Y_ENSURE_BT(Action);
        return *Action;
    }

    template <class T>
    const T* GetAs() const {
        return dynamic_cast<const T*>(Action.Get());
    }

    TUserAction::TConstPtr Impl() const {
        return Action;
    }
};

using TDBActions = TVector<TDBAction>;
