#pragma once

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/users/user.h>

#include <library/cpp/yconf/conf.h>

#include <rtline/library/geometry/coord.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/set.h>

namespace NDrive::NProto {
    class TUserPermissionsFeatures;
}

class TUserPermissionsFeatures {
    R_FIELD(bool, IsFallbackUser, false);
    R_FIELD(bool, IsPlusUser, false);
    R_FIELD(bool, IsYandexUser, false);
    R_FIELD(TString, TVMTicket);
    R_FIELD(TString, ClientIP);
    R_FIELD(TString, Uid);
    R_FIELD(TSet<TString>, DefaultEmails);
    R_FIELD(TString, PassportName);
    R_FIELD(TString, PassportDefaultAvatar);
    R_FIELD(TString, YangWorkerId);
    R_OPTIONAL(TGeoCoord, UserLocation);
    R_OPTIONAL(TString, MobilePay);

public:
    TUserPermissionsFeatures() = default;

    bool DeserializeFromProto(const NDrive::NProto::TUserPermissionsFeatures& info);
    void SerializeToProto(NDrive::NProto::TUserPermissionsFeatures& info) const;
};

class TRolesConfig {
    R_FIELD(TSet<TString>, PlusRoles);
    R_FIELD(TSet<TString>, YandexRoles);
    R_FIELD(TSet<TString>, DefaultRoles);
    R_FIELD(TSet<TString>, BaseRoles);
    R_FIELD(TSet<TString>, NecessaryRoles);
    R_FIELD(TSet<TString>, BlockedRoles);
    R_FIELD(TSet<TString>, HiddenMTRoles);
    R_FIELD(TSet<TString>, ChatRoles);
    R_FIELD(TSet<TString>, FastRegisteredRoles);
    R_FIELD(TSet<TString>, FirstRidingRoles);
    R_FIELD(TSet<TString>, FirstPlusRidingRoles);

    TMap<TString, TSet<TString>> CustomRoles;

public:
    TSet<TString> GetAdditionalRoles(const TUserPermissionsFeatures& userFeatures) const;
    TSet<TString> GetStatusSpecificRoles(const TString& status) const;

    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
