#include "before_start_process.h"

#include <drive/backend/data/additional_service.h>
#include <drive/backend/offers/offers/additional_service.h>

namespace NDrive {

    const TString TAdditionalServiceBeforeStartProcess::TypeName = "additional_service_before_start";

    TAdditionalServiceBeforeStartProcess::TFactory::TRegistrator<TAdditionalServiceBeforeStartProcess> TAdditionalServiceBeforeStartProcess::Registrator(TAdditionalServiceBeforeStartProcess::TypeName);

    TString TAdditionalServiceBeforeStartProcess::GetType() const {
        return TypeName;
    }

    NDrive::TScheme TAdditionalServiceBeforeStartProcess::DoGetScheme(const IServerBase& server) const {
        const auto impl = server.GetAs<NDrive::IServer>();
        const auto api = impl ? impl->GetDriveAPI() : nullptr;
        const auto holderTagNames = api
            ? api->GetTagsManager().GetTagsMeta().GetRegisteredTagNames({ TAdditionalServiceOfferHolderTag::Type() })
            : TSet<TString>();
        TSet<TString> notificationTagNames;
        if (api) {
            for (auto&& [name, _] : api->GetTagsManager().GetTagsMeta().GetRegisteredTags(NEntityTagsManager::EEntityType::User)) {
                notificationTagNames.insert(name);
            }
        }
        NDrive::TScheme scheme = TBase::DoGetScheme(server);
        scheme
            .Remove("notification_interval")
            .Remove("tag_names")
            .Remove("notification_tag_name");
        scheme.Add<TFSDuration>("notification_interval").SetDefault(NotificationInterval);
        scheme.Add<TFSVariants>("tag_names").SetVariants(holderTagNames).SetMultiSelect(true);
        scheme.Add<TFSVariants>("notification_tag_name").SetVariants(notificationTagNames);
        return scheme;
    }
    
    bool TAdditionalServiceBeforeStartProcess::DoCheckRunCondition(const NDrive::IServer& server, const TOfferHolderTag& offerHolderTag, NDrive::TEntitySession& tx) const {
        Y_UNUSED(server);
        Y_UNUSED(offerHolderTag);
        Y_UNUSED(tx);
        return true;
    }

    TOptionalDBTags TAdditionalServiceBeforeStartProcess::GetOfferHolders(const NDrive::IServer& server, NDrive::TEntitySession& tx) const {
        return TAdditionalServiceOfferHolderTag::RestoreOfferHolderTags({}, server, tx);
    }

    void TAdditionalServiceBeforeStartProcess::FillNotificationTag(ITag::TPtr tag, const TOfferHolderTag& offerHolderTag, const ILocalization* /*localization*/) const {
        auto serviceOffer = std::dynamic_pointer_cast<TAdditionalServiceOffer>(offerHolderTag.GetOffer());
        Y_ENSURE(serviceOffer);
        if (auto notificationTag = std::dynamic_pointer_cast<TUserMessageTagBase>(tag)) {
            notificationTag->AddMacro("_SessionId_", serviceOffer->GetOfferId());
            notificationTag->AddMacro("_ParentSessionId_", serviceOffer->GetSessionId());
        }
        if (auto landingTag = std::dynamic_pointer_cast<TLandingUserTag>(tag)) {
            landingTag->SetContextParameter("session_id", serviceOffer->GetOfferId());
            landingTag->SetContextParameter("parent_session_id", serviceOffer->GetSessionId());
        }
    }

    TInstant TAdditionalServiceBeforeStartProcess::GetScheduledAt(const TOfferHolderTag& offerHolderTag) const {
        auto serviceOffer = std::dynamic_pointer_cast<TAdditionalServiceOffer>(offerHolderTag.GetOffer());
        return Yensured(serviceOffer)->GetScheduledAt();
    }

}
