#pragma once

#include <drive/backend/rt_background/long_term/before_delivery_process.h>

namespace NDrive {

    class TAdditionalServiceBeforeStartProcess: public TLongTermBeforeDeliveryProcess {
    private:
        using TBase = TLongTermBeforeDeliveryProcess;

        static TFactory::TRegistrator<TAdditionalServiceBeforeStartProcess> Registrator;

    public:
        static const TString TypeName;

        TString GetType() const override;
    
        NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

        bool DoCheckRunCondition(const NDrive::IServer& server, const TOfferHolderTag& offerHolderTag, NDrive::TEntitySession& tx) const override;
        TOptionalDBTags GetOfferHolders(const NDrive::IServer& server, NDrive::TEntitySession& tx) const override;
        void FillNotificationTag(ITag::TPtr tag, const TOfferHolderTag& offerHolderTag, const ILocalization* localization) const override;
        TInstant GetScheduledAt(const TOfferHolderTag& offerHolderTag) const override;
    };

}
