#include "config.h"

TCarsAlertWatcher::TFactory::TRegistrator<TCarsAlertWatcher> TCarsAlertWatcher::Registrator(TCarsAlertWatcher::GetTypeName());

TExpectedState TCarsAlertWatcher::DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const {
    TVector<TString> notificationLines;
    for (auto&& i : context.GetFetchedCarsData()) {
        notificationLines.emplace_back(i.second.GetHRReport());
    }
    if (context.GetFetchedCarsData().size() >= GetNotificationCarLimit()) {
        TString message = "Предупреждение " + GetTitle() + " (" + ToString(context.GetFetchedCarsData().size()) + ")";
        if (GetFullReport()) {
            NDrive::INotifier::MultiLinesNotify(server.GetNotifier(GetNotifierName()), message + ":", notificationLines);
        } else {
            NDrive::INotifier::Notify(server.GetNotifier(GetNotifierName()), message);
        }
    }
    return new IRTBackgroundProcessState();
}

NDrive::TScheme TCarsAlertWatcher::DoGetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme = TBase::DoGetScheme(server);
    scheme.Add<TFSVariants>("notifier", "Способ нотификации").SetVariants(server.GetNotifierNames());
    scheme.Add<TFSString>("title", "Заголовок сообщения");
    scheme.Add<TFSNumeric>("cars_count_limit", "предельно допустимое количество машин").SetMin(0).SetDefault(0);
    scheme.Add<TFSBoolean>("verbose", "Список машин в сообщениях").SetDefault(false);
    return scheme;
}

bool TCarsAlertWatcher::DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) {
    JREAD_STRING(jsonInfo, "notifier", NotifierName);
    JREAD_STRING_OPT(jsonInfo, "title", Title);
    JREAD_INT(jsonInfo, "cars_count_limit", NotificationCarLimit);
    JREAD_BOOL_OPT(jsonInfo, "verbose", FullReport);
    return TBase::DoDeserializeFromJson(jsonInfo);
}

NJson::TJsonValue TCarsAlertWatcher::DoSerializeToJson() const {
    NJson::TJsonValue result = TBase::DoSerializeToJson();
    TJsonProcessor::Write(result, "notifier", NotifierName);
    TJsonProcessor::Write(result, "title", Title);
    TJsonProcessor::Write(result, "cars_count_limit", NotificationCarLimit);
    TJsonProcessor::Write(result, "verbose", FullReport);
    return result;
}
