#pragma once

#include <drive/backend/rt_background/common/config.h>

class TCarsAlertWatcher: public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, Title);
    R_READONLY(ui32, NotificationCarLimit, 1);
    R_READONLY(bool, FullReport, true);
private:
    static TFactory::TRegistrator<TCarsAlertWatcher> Registrator;
protected:
    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    using TBase::TBase;

    static TString GetTypeName() {
        return "cars_alert";
    }

};
