#pragma once

#include "watcher.h"

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/util/types/accessor.h>

class TAttachmentsExpirationWatcher: public IRTCarsProcess {
    R_READONLY(TAttachmentWatcherConfig, WatcherConfig);

private:
    using TBase = IRTCarsProcess;
    static TFactory::TRegistrator<TAttachmentsExpirationWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const override;

    static TString GetTypeName() {
        return "attachment_expiration_watcher";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
