#pragma once

#include <drive/backend/rt_background/common/config.h>

#include <drive/backend/data/user_tags.h>

class TPassCheckProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "pass_check_process";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TString NotifierName;
    TString PassCheckChatName;
    TString PassCheckLandingId;
    TString PassTagName = TUserIsolationPassTag::TypeName;
    TString PushTagName;
    TDuration PassValidationPeriod = TDuration::Hours(12);

private:
    static TFactory::TRegistrator<TPassCheckProcess> Registrator;
};

class TPassCheckStatusProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "pass_check_status_process";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    TString InvalidPassTagName;
    TString PassTagName = TUserIsolationPassTag::TypeName;

private:
    static TFactory::TRegistrator<TPassCheckProcess> Registrator;
};
