#pragma once
#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/billing/manager.h>
#include <drive/backend/billing/accounts/limited.h>

class TRTLimitedAccountsNotifier : public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    R_FIELD(TSet<TString>, AccountTypes);
    R_FIELD(TString, MailTag);
    R_FIELD(TString, TemplateBalanceParam);
    R_FIELD(ui64, MaxAccountsCount, 1000);
    R_FIELD(TDuration, NotifyPeriod, TDuration::Days(1));

public:
    using TBase::TBase;
    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    NJson::TJsonValue DoSerializeToJson() const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

protected:
    virtual TMaybe<bool> CheckRelevance(const NDrive::NBilling::TAccountsManager& manager, const NDrive::NBilling::TLimitedAccountRecord& record, NDrive::TEntitySession& session) const = 0;
    virtual TString GetLastNotificationKey(const NDrive::NBilling::TNotifySettings& settings) const = 0;
};

class TRTDailyLimitedAccountsBalanceNotifier : public TRTLimitedAccountsNotifier {
private:
    using TBase = TRTLimitedAccountsNotifier;
    static TFactory::TRegistrator<TRTDailyLimitedAccountsBalanceNotifier> Registrator;

    virtual TMaybe<bool> CheckRelevance(const NDrive::NBilling::TAccountsManager& manager, const NDrive::NBilling::TLimitedAccountRecord& record, NDrive::TEntitySession& session) const override;
    virtual TString GetLastNotificationKey(const NDrive::NBilling::TNotifySettings& settings) const override;

public:
    using TBase::TBase;
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "daily_limited_accounts_balance_notifier";
    }
};

class TRTLimitedAccountsLowBalanceNotifier : public TRTLimitedAccountsNotifier {
private:
    using TBase = TRTLimitedAccountsNotifier;
    R_OPTIONAL(TString, HistoryRefresher);
    static TFactory::TRegistrator<TRTLimitedAccountsLowBalanceNotifier> Registrator;

    virtual TMaybe<bool> CheckRelevance(const NDrive::NBilling::TAccountsManager& manager, const NDrive::NBilling::TLimitedAccountRecord& record, NDrive::TEntitySession& session) const override;
    virtual TString GetLastNotificationKey(const NDrive::NBilling::TNotifySettings& settings) const override;

public:
    using TBase::TBase;
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "limited_accounts_low_balance_notifier";
    }

    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    NJson::TJsonValue DoSerializeToJson() const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};

class TRTLimitedAccountsBalanceChangeNotifier : public TRTLimitedAccountsNotifier {
private:
    using TBase = TRTLimitedAccountsNotifier;
    R_FIELD(ui64, PercentLimit, 20);
    R_FIELD(TDuration, CheckPeriod, TDuration::Days(1));
    static TFactory::TRegistrator<TRTLimitedAccountsBalanceChangeNotifier> Registrator;

    virtual TMaybe<bool> CheckRelevance(const NDrive::NBilling::TAccountsManager& manager, const NDrive::NBilling::TLimitedAccountRecord& record, NDrive::TEntitySession& session) const override;
    virtual TString GetLastNotificationKey(const NDrive::NBilling::TNotifySettings& settings) const override;

public:
    using TBase::TBase;
    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "limited_accounts_balance_change_notifier";
    }

    NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    NJson::TJsonValue DoSerializeToJson() const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
