#pragma once
#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/billing/accounts_manager.h>
#include <drive/backend/billing/interfaces/account.h>

#include <drive/library/cpp/balance/client.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>


class TBillingManager;
class TBillingTagDescription;
class TDBTag;

class TRTBillingAccountsWatcher: public IRTRegularBackgroundProcess {
    R_READONLY(ui64, ObjectsAtOnce, 100);

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTBillingAccountsWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "billing_accounts_refresh";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    NDrive::NBilling::TAccountParentFilter AccountFilter;
};



class TRTBillingAccountsCleaner : public IRTRegularBackgroundProcess {
    R_READONLY(TSet<TString>, Accounts);
    R_READONLY(TDuration, ActivityDuration, TDuration::Days(30));
    R_READONLY(ui64, ObjectsAtOnce, 100);

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTBillingAccountsCleaner> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "billing_accounts_clean";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};

class TRTBillingB2BBalanceRefreshWatcher: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTBillingB2BBalanceRefreshWatcher> Registrator;
    R_READONLY(ui32, Service, 702);
    R_READONLY(ui32, BalanceBatch, 30);
    R_READONLY(TString, ExpiredDebtAmountTagName);
    R_READONLY(bool, DeactivateAccounts, false);
    R_READONLY(bool, VerboseLog, false);
    R_READONLY(TString, GrepLogSubstr, "AccountDebtStatus");
    R_READONLY(bool, RemoveDeprecatedTags, false);

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "billing_b2b_balance_refresh";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};

class TRTBillingUpdateUndefinedClients: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTBillingUpdateUndefinedClients> Registrator;
    R_READONLY(ui32, Service, 702);
    R_READONLY(TString, TagName);
    R_READONLY(TBalanceClient::TClient, DefaultClient);
    R_READONLY(TBalanceClient::TPerson, DefaultPerson);

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "billing_b2b_update_undefined";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
