#pragma once
#include <drive/backend/rt_background/common/state.h>
#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/proto/background.pb.h>



class TRTBillingAlertsState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTBillingAlertsState> Registrator;
protected:
    virtual TString GetType() const;
};

class TRTBillingAlerts: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTBillingAlerts> Registrator;
public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "billing_alerts";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};


class TRTBillCompareAlertsState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTBillCompareAlertsState> Registrator;
protected:
    virtual TString GetType() const;
};


class TRTBillCompareAlerts : public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTBillCompareAlerts> Registrator;
public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "bill_compare_alerts";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
