#pragma once
#include <drive/backend/rt_background/manager/settings.h>

#include <drive/backend/billing/interfaces/account.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>


class TBillingManager;
class TBillingTagDescription;
class TDBTag;

class TRTBillingTagsWatcher: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTBillingTagsWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "billing_tags_watcher";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
