#pragma once

#include <drive/backend/rt_background/common/database.h>

#include <drive/backend/billing/accounts_manager.h>

#include <rtline/util/types/accessor.h>


class TRTClearingWatcher : public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTClearingWatcher> Registrator;

    R_READONLY(ui32, TasksAtOnce, 15);
    R_READONLY(ui32, TasksAtCycle, 150);
    R_READONLY(TDuration, ClearingInterval, TDuration::Days(5));
public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "rt_clearing_watcher";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};

class TRTRefundsCycleWatcher : public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTRefundsCycleWatcher> Registrator;
public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "refunds_cycle";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
