#pragma once

#include <drive/backend/billing/accounts_manager.h>

#include <drive/backend/rt_background/manager/settings.h>
#include <drive/backend/tags/tags_filter.h>
#include <drive/backend/rt_background/common/state.h>
#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>

class TRTBillingCompilationState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTBillingCompilationState> Registrator;
public:
    virtual TString GetType() const override;
};

class TRTBillingCompilation: public IRTRegularBackgroundProcess {
    R_READONLY(TTagsFilter, OfferFilter);
    R_READONLY(TDuration, UpdatePeriod);
    R_READONLY(ui64, FirstEventId, 0);
    R_READONLY(NDrive::NBilling::TAccountParentFilter, AccountFilter);
    R_READONLY(ui32, PartSize, 50);

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTBillingCompilation> Registrator;
public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "billing_compilation";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};

class TRTAddBillingWalletsState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTAddBillingWalletsState> Registrator;
public:
    virtual TString GetType() const override;
};

class TRTAddBillingWallets: public IRTRegularBackgroundProcess {
    R_READONLY(ui64, FirstEventId, 0);
    R_READONLY(ui32, ReadPartSize, 5000);
    R_READONLY(ui32, UpdatePartSize, 100);

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TRTAddBillingWallets> Registrator;
public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "add_billing_wallets";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};
