#pragma once

#include <drive/backend/rt_background/common/database.h>

#include <drive/backend/billing/accounts_manager.h>
#include <drive/backend/billing/interfaces/account.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>


class TRTFiscalExportState : public TRTHistoryWatcherState {
    static TFactory::TRegistrator<TRTFiscalExportState> Registrator;
public:
    virtual TString GetType() const override;
};

class TRTFiscalExports: public TDBTableScanner {
    R_FIELD(TString, YTCluster);
    R_FIELD(TString, YTDir);
    R_FIELD(TSet<TString>, Accounts);
    R_FIELD(TString, ClientId);
    R_FIELD(TString, ExportPolicy);
    R_FIELD(TSet<EBillingType>, BillingTypes);
    R_FIELD(TInstant, FirstInstant, TInstant::Zero());
    R_FIELD(ui32, ParentId, 0);
    R_FIELD(bool, WithUserInfo, false);
    R_FIELD(TString, ExportType, "income");
    R_FIELD(bool, UseOperationTs, false);
    R_FIELD(bool, WithBonusAccounts, false);


private:
    using TBase = TDBTableScanner;
    static TFactory::TRegistrator<TRTFiscalExports> Registrator;
public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "fiscal_exports";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;

private:
    virtual bool ProcessRecords(const TRecordsSet& records, const NDrive::IServer& server, ui64& lastEventId, TMessagesCollector& errors) const override;
    virtual TRTHistoryWatcherState* BuildState() const override {
        return new TRTFiscalExportState();
    }

private:
    NDrive::NBilling::TAccountParentFilter AccountFilter;
};

class TB2BExportState : public TRTInstantWatcherState {
    static TFactory::TRegistrator<TB2BExportState> Registrator;
public:
    virtual TString GetType() const override;
};

class TB2BReportExports : public IRTRegularBackgroundProcess {
    R_READONLY(TSet<TString>, Accounts);
    R_READONLY(TDuration, ReportInterval, TDuration::Hours(24));
    R_READONLY(TInstant, FirstReportInstant);
    R_READONLY(TString, NotifierName);
    R_READONLY(TString, DocumentConstructorName);
    R_READONLY(TString, PackConstructorName);
    R_READONLY(TString, DocumentFileName);

private:
    using TBase = IRTRegularBackgroundProcess;
    static TFactory::TRegistrator<TB2BReportExports> Registrator;
public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "b2b_exports";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;
};

