#pragma once
#include <drive/backend/rt_background/manager/settings.h>
#include <drive/backend/rt_background/manager/state.h>

#include <drive/backend/billing/interfaces/account.h>
#include <drive/backend/proto/background.pb.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>


class TRTRefundsWatcher: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

private:
    static TFactory::TRegistrator<TRTRefundsWatcher> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "refunds_warcher";
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
};

class TDeferredRefundsWatcher: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "deferred_refunds_watcher";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

private:
    ui64 Limit = 100;

private:
    static TFactory::TRegistrator<TDeferredRefundsWatcher> Registrator;
};
