#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/registrar/ifaces.h>

#include <drive/library/cpp/scheme/scheme.h>

class TBlacklistBanActualizer: public IRTRegularBackgroundProcess {
    TVector<TString> BlacklistedTags;
    TString SimilarProfilesTag;
    NUserConnections::TSimilarityTraits Traits;
    bool Direct = true;
    bool Reverse = true;
    bool SetComment = false;
    bool VerifiedDeviceIdOnly = false;

private:
    using TBase = IRTRegularBackgroundProcess;

private:
    static TFactory::TRegistrator<TBlacklistBanActualizer> Registrator;

public:
    using TBase::TBase;

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

    static TString GetTypeName() {
        return "blacklist_bans_actualizer";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override;
};
