#include "config.h"

#include <drive/backend/database/drive_api.h>
#include <drive/backend/surge/surge_snapshot.h>

#include <drive/library/cpp/scheme/scheme.h>

TRTCarCounter::TFactory::TRegistrator<TRTCarCounter> TRTCarCounter::Registrator("car_counter");

TExpectedState TRTCarCounter::DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> /*state*/, const NDrive::IServer& server, TTagsModificationContext& context) const {
    if (GetIdleLimits().size() && !!server.GetSurgeConstructor()) {
        auto surgeInfos = server.GetSurgeConstructor()->GetInfoActual();
        auto signalIt = SignalIdleLimit.begin();
        for (auto&& currentLimit: GetIdleLimits()) {
            ui32 count = 0;
            for (auto&& i : context.GetFilteredCarIds()) {
                auto it = surgeInfos.find(i);
                if (it != surgeInfos.end() && it->second.HasIdleStart() && (ModelingNow() - it->second.GetIdleStartUnsafe()) < currentLimit) {
                    ++count;
                }
            }
            (*(signalIt++))->Signal(count);
        }
    }
    if (!!Signal) {
        Signal->Signal(context.GetFilteredCarIds().size());
    }
    return new IRTBackgroundProcessState();
}

NDrive::TScheme TRTCarCounter::DoGetScheme(const IServerBase& server) const {
    NDrive::TScheme scheme = TBase::DoGetScheme(server);
    scheme.Add<TFSString>("idle_limits", "набор duration для определения границ простоя");
    return scheme;
}
