#pragma once

#include <drive/backend/rt_background/common/config.h>
#include <drive/backend/rt_background/manager/manager.h>

#include <drive/backend/tags/tags_filter.h>

#include <drive/library/cpp/scheme/scheme.h>

class TRTCarLockers: public IRTCarsProcess {
private:
    using TBase = IRTCarsProcess;
private:
    static TFactory::TRegistrator<TRTCarLockers> Registrator;
    TString CommonSignalPrefix;
    bool NeedStatusCount = true;
    bool NeedLockersCount = true;
    bool NeedLockersPerformingCount = true;
public:

    virtual bool IsSimultaneousProcess() const override {
        return true;
    }

    virtual TString GetType() const override {
        return "car_lockers";
    }

    using TBase::TBase;

    virtual TExpectedState DoExecuteFiltered(TAtomicSharedPtr<IRTBackgroundProcessState> state, const NDrive::IServer& server, TTagsModificationContext& context) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;

    virtual NJson::TJsonValue DoSerializeToJson() const override {
        NJson::TJsonValue result = TBase::DoSerializeToJson();
        JWRITE(result, "common_prefix", CommonSignalPrefix);
        JWRITE(result, "need_status_count", NeedStatusCount);
        JWRITE(result, "need_lockers_count", NeedLockersCount);
        JWRITE(result, "need_lockers_perform", NeedLockersPerformingCount);

        return result;
    }

    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonInfo) override {
        if (!TBase::DoDeserializeFromJson(jsonInfo)) {
            return false;
        }
        JREAD_BOOL_OPT(jsonInfo, "need_status_count", NeedStatusCount);
        JREAD_BOOL_OPT(jsonInfo, "need_lockers_count", NeedLockersCount);
        JREAD_BOOL_OPT(jsonInfo, "need_lockers_perform", NeedLockersPerformingCount);
        JREAD_STRING_OPT(jsonInfo, "common_prefix", CommonSignalPrefix);
        return true;
    }

};
