#pragma once

#include <drive/backend/rt_background/manager/settings.h>

class TCarStatusWatcherProcess: public IRTRegularBackgroundProcess {
private:
    using TBase = IRTRegularBackgroundProcess;

public:
    using TBase::TBase;

    virtual TString GetType() const override {
        return GetTypeName();
    }

    static TString GetTypeName() {
        return "car_status_watcher";
    }

    virtual TExpectedState DoExecute(TAtomicSharedPtr<IRTBackgroundProcessState> state, const TExecutionContext& context) const override;

private:
    static TFactory::TRegistrator<TCarStatusWatcherProcess> Registrator;
};
